# src/middlewares/logging.py
import logging
from aiogram import BaseMiddleware
from aiogram.types import Message

logging.basicConfig(
    filename="logs/bot.log",
    level=logging.INFO,
    format="%(asctime)s - %(levelname)s - %(message)s"
)

class LoggingMiddleware(BaseMiddleware):
    async def __call__(self, handler, event: Message, data):
        logging.info(f"User {event.from_user.id} sent: {event.text}")
        return await handler(event, data)