# src/handlers/start.py
from aiogram import Router, F
from aiogram.filters import CommandStart
from aiogram.types import Message
from src.database.queries import upsert_user, log_action

router = Router()

@router.message(CommandStart())
async def cmd_start(message: Message, pool):
    # ثبت کاربر در دیتابیس
    await upsert_user(
        pool,
        user_id=message.from_user.id,
        username=message.from_user.username,
        first_name=message.from_user.first_name,
        last_name=message.from_user.last_name,
        language_code=message.from_user.language_code
    )
    # ثبت لاگ
    await log_action(pool, message.from_user.id, "start_command", "User started the bot")
    # ارسال پیام خوش‌آمد
    await message.answer(
        "Welcome to Crypto Signal Bot! 🚀\n"
        "Use /help to see available commands."
    )