# src/database/queries.py
async def upsert_user(pool, user_id, username, first_name, last_name, language_code):
    query = """
    INSERT INTO users (user_id, username, first_name, last_name, language_code)
    VALUES ($1, $2, $3, $4, $5)
    ON CONFLICT (user_id) DO UPDATE
    SET username = EXCLUDED.username,
        first_name = EXCLUDED.first_name,
        last_name = EXCLUDED.last_name,
        language_code = EXCLUDED.language_code
    """
    async with pool.acquire() as conn:
        await conn.execute(query, user_id, username, first_name, last_name, language_code)

async def log_action(pool, user_id, action, details):
    query = """
    INSERT INTO audit_logs (user_id, action, details)
    VALUES ($1, $2, $3)
    """
    async with pool.acquire() as conn:
        await conn.execute(query, user_id, action, details)