import asyncio
import logging
from aiogram import Bot, Dispatcher
from aiogram.client.session.aiohttp import AiohttpSession
from src.config.settings import BOT_TOKEN
from src.database.connection import create_pool
from src.handlers.start import router as start_router
from src.middlewares.logging import LoggingMiddleware

async def main():
    logging.basicConfig(
        level=logging.INFO,
        format="%(asctime)s - %(levelname)s - %(message)s"
    )
    pool = await create_pool()
    proxy = None  # پروکسی VPN یا پروکسی خودت رو بذار
    session = AiohttpSession(proxy=proxy)
    bot = Bot(token=BOT_TOKEN, session=session)
    dp = Dispatcher()
    dp.message.middleware(LoggingMiddleware())
    dp.include_router(start_router)
    dp.workflow_data.update({"pool": pool})
    await dp.start_polling(bot)

if __name__ == "__main__":
    asyncio.run(main())