<?php
defined('ABSPATH') or die('No script kiddies please!!');
$art_settings = get_option('art_settings');

/**
 * Filters settings before rendering Article Read Time Block
 * 
 * @param array $art_settings
 * @since 1.0.0
 */
$art_settings = apply_filters('art_frontend_settings', $art_settings);

$word_per_minute = $art_settings['basic']['word_per_minute'];
$image_per_minute = (!empty($art_settings['basic']['image_per_minute'])) ? $art_settings['basic']['image_per_minute'] : '10';
$image_include = (!empty($art_settings['basic']['image_include'])) ? $art_settings['basic']['image_include'] : false;

$comment_include = (!empty($art_settings['basic']['comment_include'])) ? $art_settings['basic']['comment_include'] : false;
if ($comment_include == 1) {
    // Fetch approved comments for the current post
    $comments = get_comments(array(
        'post_id' => get_the_ID(),
        'status'  => 'approve',
    ));

    // Initialize the total word count for comments
    $comment_word_count = 0;

    // Calculate the word count for each comment
    foreach ($comments as $comment) {
        $comment_word_count += str_word_count(strip_tags($comment->comment_content));
    }

    // Calculate reading time for comments
    $reading_time_comments = ceil($comment_word_count / $word_per_minute);
} else {
    $reading_time_comments = 0;
}
if ($art_settings['layout']['display_type'] == 'paragraph') {
    include(ART_PATH . '/includes/cores/art-paragraph.php');
} else {
    include(ART_PATH . '/includes/cores/art-block.php');
}
include(ART_PATH . '/includes/cores/customize.php');
