<?php defined('ABSPATH') or die('No script kiddies please!!');
$art_settings = get_option('art_settings');
?>

<div class="wrap art-wrap">

    <div class="wrap art-wrap">
        <div class="art-header">
            <h1 class="art-floatLeft">
                <img src="<?php echo ART_IMG_DIR . '/art-mains.png'; ?>" class="art-plugin-logo">

            </h1>
            <div class="art-sub-header"><?php esc_html_e('Article Read Time Settings', 'article-read-time'); ?></div>

        </div>
    </div>
    <!-- End of header section -->
    <?php
    if (!empty($_GET['message']) && $_GET['message'] == 1) {
    ?>
        <div class="notice notice-info is-dismissible inline">
            <p>
                <?php esc_html_e('Settings saved successfully.', 'article-read-time'); ?>
            </p>
        </div>
    <?php
    }
    ?>
    <h2 class="nav-tab-wrapper wp-clearfix">
        <?php
        $art_tabs = array(
            'basic' => array('label' => __('Basic Settings', 'article-read-time'), 'icon' => __('dashicons dashicons-admin-generic')),
            'layout' => array('label' => __('Layout Settings', 'article-read-time'), 'icon' => __('dashicons dashicons-layout', 'article-read-time')),
            'customize' => array('label' => __('Customize', 'article-read-time'), 'icon' => __('dashicons dashicons-admin-settings', 'article-read-time'))
        );


        $art_tab_counter = 0;
        foreach ($art_tabs as $art_tab => $art_tab_detail) {
            $art_tab_counter++;
        ?>
            <a href="javascript:void(0);" class="nav-tab <?php echo ($art_tab_counter == 1) ? 'nav-tab-active' : ''; ?> art-tab-trigger" data-settings-ref="<?php echo esc_attr($art_tab); ?>"><span class="<?php echo esc_attr($art_tab_detail['icon']); ?>"></span><?php echo esc_attr($art_tab_detail['label']); ?></a>
        <?php
        }
        ?>

    </h2>

    <div class="art-settings-wrap">

        <form method="post" class="art-form" action="<?php echo admin_url('admin-post.php'); ?>">
            <?php
            include(ART_PATH . 'includes/views/backend/boxes/basic-settings.php');
            include(ART_PATH . 'includes/views/backend/boxes/layout-settings.php');
            include(ART_PATH . 'includes/views/backend/boxes/customize-settings.php');

            ?>
            <div class="art-field-wrap">

                <div class="art-field-wrap  art-settings-action">

                    <label></label>
                    <div class="art-field">
                        <input type="submit" class="button-primary" value="<?php esc_html_e('Save Settings', 'article-read-time'); ?>" />
                    </div>
                </div>

        </form>

    </div>
</div>