<?php defined('ABSPATH') or die('No script kiddies please!!'); ?>
<div class="art-settings-section" data-settings-ref="progress-bar">
    <?php wp_nonce_field('art_progress_bar_settings_nonce', 'art_progress_bar_settings_nonce_field'); ?>
    <input type="hidden" name="action" value="art_progress_bar_settings_save_action" />
    <?php
    $progress_bar_status = (!empty($art_progress_bar_settings['progress-bar']['status'])) ? $art_progress_bar_settings['progress-bar']['status'] : '';
    ?>
    <div class="art-field-wrap">
        <div class="art-field-wrap">
            <label><?php esc_html_e('Progress Bar Status', 'article-read-time'); ?></label>
            <div class="art-field">
                <input type="checkbox" id="art-progress-status" name="art_progress_bar_settings[progress-bar][status]" value="1" <?php checked($progress_bar_status, '1'); ?>>
            </div>
        </div>

        <div class="art-progress-wrap" <?php if ($progress_bar_status  == '') { ?>style="display:none" <?php } ?>>
            <?php
            $bar_display_position = (!empty($art_progress_bar_settings['progress-bar']['bar_display_position'])) ? $art_progress_bar_settings['progress-bar']['bar_display_position'] : 'top';
            ?>
            <div class="art-field-wrap">
                <label><?php esc_html_e('Display Position', 'article-read-time'); ?></label>
                <div class="art-field">
                    <select name="art_progress_bar_settings[progress-bar][bar_display_position]" class="art-display-position-dropdown">
                        <option value="top" <?php selected($bar_display_position, 'top'); ?>><?php echo esc_html_e('Top of the post/page'); ?></option>
                        <option value="bottom" <?php selected($bar_display_position, 'bottom'); ?>><?php esc_html_e(
                                                                                                        'Bottom of the post/page'
                                                                                                    ); ?></option>
                        <option value="none" <?php selected($bar_display_position, 'none'); ?>><?php esc_html_e(
                                                                                                    'none'
                                                                                                ); ?></option>
                    </select>
                </div>
            </div>
            <?php
            $display_style = (!empty($art_progress_bar_settings['progress-bar']['display_style'])) ? $art_progress_bar_settings['progress-bar']['display_style'] : 'normal'; ?>
            <div class="art-field-wrap art-display-style" <?php if ($bar_display_position == 'none') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Display Styles', 'article-read-time'); ?></label>
                <div class="art-field">
                    <select name="art_progress_bar_settings[progress-bar][display_style]" class="art-display-style-dropdown">
                        <option value="normal" <?php selected($display_style, 'normal'); ?>><?php echo esc_html_e('Normal'); ?></option>
                        <option value="gradient" <?php selected($display_style, 'gradient'); ?>><?php esc_html_e('Gradient'); ?></option>
                    </select>
                </div>
            </div>
            <?php
            $gradient_style = (!empty($art_progress_bar_settings['progress-bar']['display_gradient_style'])) ? $art_progress_bar_settings['progress-bar']['display_gradient_style'] : 'top-bottom';
            ?>
            <div class="art-field-wrap art-gradient-style" <?php if ($bar_display_position == 'none' ||  $display_style == 'normal') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Gradient Styles', 'article-read-time'); ?></label>
                <div class="art-field">
                    <select name="art_progress_bar_settings[progress-bar][display_gradient_style]" class="art-display-gradient-style-dropdown">
                        <option value="top-bottom" <?php selected($gradient_style, 'top-bottom'); ?>><?php echo esc_html_e('Top to Bottom'); ?></option>
                        <option value="left-right" <?php selected($gradient_style, 'left-right'); ?>><?php esc_html_e('Left to Right'); ?></option>
                        <option value="topleft-bottomright" <?php selected($gradient_style, 'topleft-bottomright'); ?>><?php esc_html_e('Top Left to Right Bottom'); ?></option>
                    </select>
                </div>
            </div>


            <div class="art-field-wrap art-normal-ref" <?php if ($bar_display_position == 'none') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Background Color', 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_progress_bar_settings[progress-bar][background_color]" class="art-form-field art-colorpicker" value="<?php echo esc_attr($art_progress_bar_settings['progress-bar']['background_color']) ?>" />
                </div>
            </div>
            <div class="art-field-wrap art-normal-ref" <?php if ($bar_display_position == 'none') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Primary Color', 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_progress_bar_settings[progress-bar][primary_color]" class="art-form-field art-colorpicker" value="<?php echo esc_attr($art_progress_bar_settings['progress-bar']['primary_color']) ?>" />
                </div>
            </div>
            <?php
            $progress_bar_display_style = (!empty($art_progress_bar_settings['progress-bar']['display_style'])) ? $art_progress_bar_settings['progress-bar']['display_style'] : 'normal';
            ?>
            <div class="art-field-wrap art-gradient-ref" <?php if ($progress_bar_display_style == 'normal') { ?>style="display:none" <?php } ?> <?php if ($bar_display_position == 'none') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Secondary Color', 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_progress_bar_settings[progress-bar][secondary_color]" class="art-form-field art-colorpicker" value="<?php echo esc_attr($art_progress_bar_settings['progress-bar']['secondary_color']) ?>" />
                </div>
            </div>


            <div class="art-field-wrap art-progress-bar-thickness" <?php if ($bar_display_position == 'none') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e('Bar Thickness:', 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="number" name="art_progress_bar_settings[progress-bar][bar_thickness]" value="<?php echo (!empty($art_progress_bar_settings['progress-bar']['bar_thickness'])) ? esc_attr($art_progress_bar_settings['progress-bar']['bar_thickness']) : '12'; ?>" />
                    <p class="description"><?php esc_html_e('(defaults thickness,12)'); ?></p>
                </div>
            </div>

            <h3><?php esc_html_e('Select Post Type to Display', 'article-read-time'); ?></h3>
            <?php

            $args       = array(
                'public' => true,
            );
            $all_post_types = get_post_types($args, 'names');
            foreach ($all_post_types as $post_type) {
            ?>
                <div class="art-field-wrap">
                    <label>
                        <?php
                        /* translators: %s is replaced with "post type name" */
                        echo sprintf(esc_html__('Display on %s', 'article-read-time'), esc_html(ucfirst($post_type)));
                        ?>
                    </label>
                    <div class="art-field">
                        <?php
                        $selected_post_types_prorgress_bar = (!empty($art_progress_bar_settings['progress-bar']['display_post_types_progress_bar'])) ? $art_progress_bar_settings['progress-bar']['display_post_types_progress_bar'] : [];

                        ?>
                        <div class="art-field art-checkbox-toggle">
                            <input type="checkbox" name="art_progress_bar_settings[progress-bar][display_post_types_progress_bar][<?php echo esc_attr($post_type); ?>]" value="<?php echo esc_attr($post_type); ?>" <?php echo esc_attr((in_array($post_type, $selected_post_types_prorgress_bar))) ? 'checked="checked"' : ''; ?>>
                            <label></label>
                        </div>

                    </div>
                </div>
                <div class="art-field-wrap">
                    <label>
                        <?php
                        /* translators: %s is replaced with "post type name" */
                        echo sprintf(esc_html__('Display on Specific %s', 'article-read-time'), esc_html(ucfirst($post_type)));
                        ?>
                    </label>
                    <div class="art-field">
                        <input type="text" name="art_progress_bar_settings[progress-bar][display_specific][<?php echo esc_attr($post_type); ?>]" value="<?php echo (!empty($art_progress_bar_settings['progress-bar']['display_specific'][$post_type])) ? esc_attr($art_progress_bar_settings['progress-bar']['display_specific'][$post_type]) : ''; ?>">
                        <p class="description">
                            <?php
                            /* translators: %s is replaced with "post type name" */
                            echo sprintf(esc_html__('Please enter the comma separated slugs of %s if you want to display menu on those specific %s only', 'article-read-time-pro'), $post_type, $post_type);
                            ?>
                        </p>
                    </div>
                </div>
            <?php } ?>

        </div>
    </div>
</div>