<?php defined('ABSPATH') or die('No script kiddies please!!'); ?>
<div class="art-settings-section" data-settings-ref="layout" style="display:none;">
    <div class="art-field-wrap">
        <?php
        $display_section = (!empty($art_settings['layout']['display_section'])) ? $art_settings['layout']['display_section'] : 'beginning';
        ?>
        <div class="art-field-wrap">
            <label><?php esc_html_e('Display Section', 'article-read-time'); ?></label>
            <div class="art-field">
                <select name="art_settings[layout][display_section]">
                    <option value="beginning" <?php selected($display_section, 'beginning'); ?>>
                        <?php echo esc_html_e('Beginning of the Content'); ?>
                    </option>
                    <option value="end" <?php selected($display_section, 'end'); ?>><?php esc_html_e('End of the content', 'article-read-time'); ?></option>
                    <option value="both" <?php selected($display_section, 'both'); ?>><?php esc_html_e('Both', 'article-read-time'); ?></option>
                </select>
            </div>
        </div>
        <?php

        $layout_display_type_check = (!empty($art_settings['layout']['display_type'])) ? $art_settings['layout']['display_type'] : 'paragraph';
        ?>
        <div class="art-field-wrap">
            <label><?php esc_html_e('Display Type', 'article-read-time'); ?></label>
            <div class="art-field">
                <select name="art_settings[layout][display_type]" class="art-display-type-dropdown">
                    <option value="paragraph" <?php selected($layout_display_type_check, 'paragraph'); ?>><?php echo esc_html_e('Paragraph Type'); ?></option>
                    <option value="block" <?php selected($layout_display_type_check, 'block'); ?>><?php esc_html_e('Block Type', 'article-read-time'); ?>
                    </option>
                </select>

            </div>
        </div>
        <?php

        $paragraph_template_check = (!empty($art_settings['layout']['paragraph_template'])) ? $art_settings['layout']['paragraph_template'] : 'template-1';
        ?>

        <div class="art-field-wrap art-paragraph-ref" <?php if ($layout_display_type_check == 'block') { ?>style="display:none" <?php } ?>>
            <label><?php esc_html_e('Choose Paragraph Template', 'article-read-time'); ?></label>
            <div class="art-field">
                <select name="art_settings[layout][paragraph_template]"
                    class="art-form-field art-template-dropdown-paragraph">
                    <?php

                    for ($i = 1; $i <= 10; $i++) {
                    ?>

                        <option value="template-<?php echo esc_attr($i); ?>" <?php selected($paragraph_template_check, 'template-' . $i); ?>><?php echo __('Template ', 'article-read-time') . $i; ?></option>
                    <?php
                    }
                    ?>

                </select>

                <div class="art-template-previews-wrap">
                    <?php for ($i = 1; $i <= 10; $i++) {
                    ?>
                        <div class="art-each-template-preview-paragraph" <?php if ('template-' . $i != $paragraph_template_check) { ?>style="display:none" <?php } ?>
                            data-template-ref="template-<?php echo intval($i); ?>"><img
                                src="<?php echo ART_IMG_DIR . '/template-paragraph/template-' . $i . '.png'; ?>"
                                class="image" /></div>
                    <?php
                    }
                    ?>

                </div>

            </div>
        </div>
        <?php

        $block_template_check = (!empty($art_settings['layout']['block_template'])) ?
            $art_settings['layout']['block_template'] : 'template-1';
        ?>
        <div class="art-field-wrap art-block-ref" <?php if ($layout_display_type_check == 'paragraph') { ?>style="display:none" <?php } ?>>
            <label><?php esc_html_e('Choose Block Template', 'article-read-time'); ?></label>
            <div class="art-field">
                <select name="art_settings[layout][block_template]"
                    class="art-form-field art-template-dropdown-block">
                    <?php

                    for ($i = 1; $i <= 10; $i++) {
                    ?>

                        <option value="template-<?php echo esc_attr($i); ?>" <?php selected($block_template_check, 'template-' . $i); ?>>
                            <?php echo __('Template ', 'article-read-time') . $i; ?>
                        </option>
                    <?php
                    }
                    ?>

                </select>

                <div class="art-template-previews-wrap">
                    <?php for ($i = 1; $i <= 10; $i++) {
                    ?>
                        <div class="art-each-template-preview-block" <?php if ('template-' . $i != $block_template_check) { ?>style="display:none" <?php } ?> data-template-ref="template-<?php echo esc_attr($i); ?>">
                            <img src="<?php echo ART_IMG_DIR . '/template-block/template-' . $i . '.png'; ?> " class="image" />
                        </div>
                    <?php
                    }
                    ?>
                </div>
            </div>
        </div>

        <div class="art-field-wrap">
            <label><?php esc_html_e('Heading Text', 'article-read-time'); ?></label>
            <div class="art-field">
                <input type="text" name="art_settings[layout][heading_text]"
                    value="<?php echo esc_attr((!empty($art_settings['layout']['heading_text']))) ? esc_attr($art_settings['layout']['heading_text']) : 'Article Read Time'; ?>" />
            </div>

        </div>
        <div class="art-field-wrap art-paragraph-ref" <?php if ($layout_display_type_check == 'block') { ?>style="display:none" <?php } ?>>
            <label><?php esc_html_e('Word/Character Count Message', 'article-read-time'); ?></label>
            <div class="art-field">
                <textarea name="art_settings[layout][word_message]" rows="4" cols="50"><?php echo esc_attr((!empty($art_settings['layout']['word_message']))) ? rtrim($art_settings['layout']['word_message']) : 'This post has [word_count] words .This post has [character_count]  characters.This post take [time] minute to read.'; ?></textarea>

                <p class="description">
                    <?php esc_html_e('Please use [word_count] for word count , [character_count] for character count and [time] for reading time', 'article-read-time'); ?>
                </p>
            </div>
        </div>
        <?php

        $word_status = (!empty($art_settings['layout']['word_enable'])) ? $art_settings['layout']['word_enable'] : '';
        ?>
        <div class="art-block-ref" <?php if ($layout_display_type_check == 'paragraph') { ?>style="display:none" <?php } ?>>
            <div class="art-field-wrap art-block-ref">
                <label><?php esc_html_e("Word Enable", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="checkbox" id="art-word" name="art_settings[layout][word_enable]" value="1" <?php checked($art_settings['layout']['word_enable'], '1'); ?>>
                </div>

            </div>

            <div class="art-field-wrap art-word-wrap" <?php if (empty($word_status)) { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e("Word Label", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_settings[layout][word_field_label]" value="<?php echo esc_attr((!empty($art_settings['layout']['word_field_label']))) ? esc_attr($art_settings['layout']['word_field_label']) : 'Words'; ?>">
                </div>
            </div>
            <?php $char_status = (!empty($art_settings['layout']['character_enable'])) ? $art_settings['layout']['character_enable'] : ''; ?>
            <div class="art-field-wrap">
                <label><?php esc_html_e("Character Enable", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="checkbox" id="art-char" name="art_settings[layout][character_enable]" value="1" <?php checked($art_settings['layout']['character_enable'], '1'); ?>>
                </div>
            </div>
            <div class="art-field-wrap art-char-wrap" <?php if ($char_status == '') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e("Character Label", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_settings[layout][character_field_label]" value="<?php echo esc_attr((!empty($art_settings['layout']['character_field_label']))) ? esc_attr($art_settings['layout']['character_field_label']) : 'Characters'; ?>">
                </div>
            </div>
            <?php $read_status = (!empty($art_settings['layout']['read_enable'])) ? $art_settings['layout']['read_enable'] : ''; ?>
            <div class="art-field-wrap">
                <label><?php esc_html_e("Read Enable", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="checkbox" id="art-read" name="art_settings[layout][read_enable]" value="1" <?php checked($art_settings['layout']['read_enable'], '1'); ?>>
                </div>
            </div>
            <div class="art-field-wrap art-read-wrap" <?php if ($read_status == '') { ?>style="display:none" <?php } ?>>
                <label><?php esc_html_e("Read Label", 'article-read-time'); ?></label>
                <div class="art-field">
                    <input type="text" name="art_settings[layout][read_field_label]" value="<?php echo esc_attr((!empty($art_settings['layout']['read_field_label']))) ? esc_attr($art_settings['layout']['read_field_label']) : 'Read Time'; ?>">
                </div>


            </div>
        </div>


    </div>
</div>