<?php defined('ABSPATH') or die('No script kiddies please!!'); ?>
<div class="art-settings-section" data-settings-ref="basic">
    <?php wp_nonce_field('art_settings_nonce', 'art_settings_nonce_field'); ?>
    <input type="hidden" name="action" value="art_settings_save_action" />
    <?php
    $main_status = (!empty($art_settings['basic']['status'])) ? $art_settings['basic']['status'] : '';
    $img_include = (!empty($art_settings['basic']['image_include'])) ? $art_settings['basic']['image_include'] : '';
    $comment_include = (!empty($art_settings['basic']['comment_include'])) ? $art_settings['basic']['comment_include'] : '';
    ?>
    <div class="art-field-wrap">
        <label><?php esc_html_e('Status', 'article-read-time'); ?></label>
        <div class="art-field art-checkbox-toggle">
            <input type="checkbox" id="art-basic-status" name="art_settings[basic][status]" value="1" <?php checked($main_status, '1'); ?> />
            <label></label>
        </div>
    </div>

    <?php

    $basic_status = (!empty($art_settings['basic']['status'])) ? $art_settings['basic']['status'] : '';
    ?>
    <div class="art-basic-wrap" <?php if ($basic_status  == '') { ?>style="display:none" <?php } ?>>
        <div class="art-field-wrap">
            <label><?php esc_html_e('Words Per Minute', 'article-read-time'); ?></label>
            <div class="art-field">
                <input type="number" name="art_settings[basic][word_per_minute]" value="<?php echo (!empty($art_settings['basic']['word_per_minute'])) ? esc_attr($art_settings['basic']['word_per_minute']) : '300'; ?>" />
                <p class="description"><?php esc_html_e('(defaults word per minute to 300, the average article  reading speed for adults)'); ?></p>
            </div>

        </div>

        <div class="art-field-wrap">
            <label><?php esc_html_e('Include Comments', 'article-read-time'); ?></label>
            <div class="art-field art-checkbox-toggle">
                <input type="checkbox" name="art_settings[basic][comment_include]" value="1"
                    <?php checked($comment_include, '1'); ?> />
                <label></label>
            </div>
        </div>
        <div class="art-field-wrap">
            <label><?php esc_html_e('Include Image', 'article-read-time'); ?></label>
            <div class="art-field art-checkbox-toggle">
                <input type="checkbox" id="art-img-status" name="art_settings[basic][image_include]"
                    value="1" <?php checked($img_include, '1'); ?> />
                <label></label>
            </div>
        </div>
        <?php
        $img_time = (!empty($art_settings['basic']['image_per_minute'])) ? esc_attr($art_settings['basic']['image_per_minute']) : '10';
        ?>
        <div class="art-field-wrap art-img-wrap" <?php if ($img_include  == '') { ?>style="display:none" <?php } ?>>
            <label><?php esc_html_e('Image reading time in seconds', 'article-read-time'); ?></label>
            <div class="art-field">
                <input type="number" name="art_settings[basic][image_per_minute]" value="<?php echo (!empty($img_time)) ? $img_time : '10'; ?>" />
                <p class="description">
                    <?php esc_html_e('(defaults image time to 10 second, the average article image viewing speed for adults)'); ?>
                </p>
            </div>

        </div>


        <h3><?php esc_html_e('Select Post Type to Display', 'article-read-time'); ?></h3>
        <?php
        $args = ['public' => true];
        $post_types = get_post_types($args, 'names');
        foreach ($post_types as $post_type) {
        ?>
            <div class="art-field-wrap">
                <label><?php esc_html_e("Display on $post_type", 'article-read-time'); ?></label>
                <div class="art-field">
                    <?php $selected_display_post_types = (!empty($art_settings['basic']['display_post_types'])) ? $art_settings['basic']['display_post_types'] : []; ?>
                    <div class="art-field art-checkbox-toggle">
                        <input type="checkbox" name="art_settings[basic][display_post_types][<?php echo esc_attr($post_type); ?>]" value="<?php echo esc_attr($post_type); ?>" <?php echo esc_attr((in_array($post_type, $selected_display_post_types))) ? 'checked="checked"' : ''; ?>>
                        <label></label>
                    </div>
                </div>
            </div>
            <div class="art-field-wrap">
                <label>
                    <?php
                    /* translators: %s is replaced with "post type name" */
                    echo sprintf(esc_html__('Display on Specific %s', 'article-read-time'), esc_html(ucfirst($post_type)));
                    ?>
                </label>
                <div class="art-field">
                    <input type="text" name="art_settings[basic][display_specific][<?php echo esc_attr($post_type); ?>]" value="<?php echo (!empty($art_settings['basic']['display_specific'][$post_type])) ? esc_attr($art_settings['basic']['display_specific'][$post_type]) : ''; ?>">
                    <p class="description">
                        <?php
                        /* translators: %s is replaced with "post type name" */
                        echo sprintf(esc_html__('Please enter the comma separated slugs of %s if you want to display menu on those specific %s only', 'article-read-time-pro'), $post_type, $post_type);
                        ?>
                    </p>
                </div>
            </div>
        <?php } ?>
    </div>
</div>