<?php
defined('ABSPATH') or die('No script kiddies please!!');
$paragraph_template = $art_settings['layout']['paragraph_template'];
$template_class = 'art-paragraph-' . $paragraph_template;
?>

<div class="art-main-wrapper <?php echo esc_attr($template_class); ?>">
    <div class="art-col-3 art-col-s-12">
        <div class="art-feature">
            <div class="art-feature-background">
                <?php
                if (!empty($art_settings['layout']['heading_text'])) { ?>
                    <div class="art-heading">
                        <img src="<?php echo ART_IMG_DIR . '/paragraphicon.svg'; ?>">
                        <span><?php echo esc_html($art_settings['layout']['heading_text']); ?></span>
                    </div>
                <?php } ?>
                <div class="art-paragraph">
                    <div class="art-feature-paragraph">
                        <?php
                        $wordCount = str_word_count(strip_tags($content));
                        $imageCount = substr_count($content, '<img ');
                        if ($comment_include == 1) {
                            $wordCount = $wordCount + $comment_word_count;
                        }
                        // Calculate reading time for text
                        $reading_time_text = round($wordCount / $word_per_minute);
                        $total_time = ceil($reading_time_text + $reading_time_comments);
                        if ($image_include == 1) {
                            // Calculate time for images
                            $image_time_minutes = ($imageCount * $image_per_minute) / 60;

                            // Total reading time including images
                            $total_time = ceil($reading_time_text + $image_time_minutes + $reading_time_comments);
                        }
                        $before_replace = $art_settings['layout']['word_message'];

                        $final_replace = str_replace("[word_count]", '<span class="art-time">' . $wordCount . '</span class="art-time">', $before_replace);

                        $len = strlen(strip_tags($content));
                        if ($comment_include == 1) {
                            $len = $len + $comment_word_count;
                        }
                        $final_replace = str_replace("[character_count]", '<span class="art-time">' . $len . '</span class="art-time">', $final_replace);



                        global $post;
                        $art = get_post_meta($post->ID, 'art_post', true);

                        $custom_time = (!empty($art['custom_time'])) ? $art['custom_time'] : '';
                        if (!empty($custom_time)) {
                            $final_replace = str_replace("[time]", '<span class="art-time">' . $custom_time . '</span class="art-time">', $final_replace);
                            echo nl2br(wp_kses_post($final_replace));
                        } else {
                            

                            $sec = $wordCount / $word_per_minute;
                            $seconds = number_format($sec, 3);
                            if ($total_time == 1) {

                                $final_replace = str_replace("[time]", '<span class="art-time">' . $total_time . '</span class="art-time">', $final_replace);
                            } elseif ($seconds < 1) {

                                $final_replace = str_replace("[time]", '<span class="art-time">' . $seconds . '</span class="art-time">', $final_replace);
                            } else {

                                $final_replace = str_replace("[time]", '<span class="art-time">' . $total_time . '</span class="art-time">', $final_replace);
                            }

                            echo nl2br(wp_kses_post($final_replace));
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</div>