<?php
defined('ABSPATH') or die('No script kiddies please!!');
$block_template = $art_settings['layout']['block_template'];
$template_class = (!empty($_GET['template_class'])) ? sanitize_text_field($_GET['template_class']) : 'art-block-' . $block_template;
$word_per_minute =  $art_settings['basic']['word_per_minute'];
?>
<div class="art-main-wrapper <?php echo esc_html($template_class); ?>">
    <h3 class="art-main-heading"> <?php echo esc_html($art_settings['layout']['heading_text']); ?></h3>
    <div class="art-col-3 art-col-s-12">
        <div class="art-feature">
            <div class="art-feature-section">
                <?php
                $word_status = $art_settings['layout']['word_enable'];

                if ($word_status == 1) {
                    $blockwordCount = str_word_count(strip_tags($content));
                    if ($comment_include == 1) {
                        $blockwordCount = $blockwordCount + $comment_word_count;
                    }
                ?>
                    <div class="art-word">
                        <div class="art-text1">
                            <?php echo esc_html($blockwordCount); ?>
                        </div>
                        <?php
                        if ($template_class == "art-block-template-1" || $template_class == "art-block-template-3" || $template_class == "art-block-template-5") { ?>
                            <div class="art-text2">
                                <?php echo esc_html((!empty($art_settings['layout']['word_field_label']))) ? esc_html($art_settings['layout']['word_field_label']) : ''; ?>
                            </div>
                        <?php } else { ?>
                            <div class="art-text2">

                                <?php include(ART_PATH . 'assets/icons/word-icon.php'); ?>

                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php
                $character_status = $art_settings['layout']['character_enable'];
                if ($character_status == 1) {
                    $blockcharacterlen = strlen(strip_tags($content));
                    if ($comment_include == 1) {
                        $blockcharacterlen = $blockcharacterlen + $comment_word_count;
                    }
                ?>
                    <div class="art-character">
                        <div class="art-text1">
                            <?php echo esc_html($blockcharacterlen); ?>
                        </div>
                        <?php
                        if ($template_class == "art-block-template-1" || $template_class == "art-block-template-3" || $template_class == "art-block-template-5") { ?>
                            <div class="art-text2">
                                <?php echo esc_html((!empty($art_settings['layout']['character_field_label']))) ? esc_html($art_settings['layout']['character_field_label']) : ''; ?>
                            </div>
                        <?php } else {  ?>
                            <div class="art-text2">

                                <?php include(ART_PATH . 'assets/icons/character-icon.php'); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } ?>
                <?php
                $time_status = $art_settings['layout']['read_enable'];
                if ($time_status == 1) {
                    global $post;
                    $art_block_post = get_post_meta( $post->ID, 'art_post', true );
                   
                    $custom_time = (!empty($art_block_post['custom_time']))?$art_block_post['custom_time']:'';
                    if(!empty($custom_time)) {
                        ?>
                              <div class="art-block-time">
                        <div class="art-text1">
                            <?php

                                echo esc_html($custom_time);
                         
                            ?>
                        </div>
                        <?php
                        if ($template_class == "art-block-template-1" || $template_class == "art-block-template-3" || $template_class == "art-block-template-5") { ?>
                            <div class="art-text2">
                                <?php echo esc_html((!empty($art_settings['layout']['read_field_label']))) ? esc_html($art_settings['layout']['read_field_label']) : ''; ?>
                            </div>
                        <?php } else { ?>
                            <div class="art-text2">

                                <?php include(ART_PATH . 'assets/icons/time-icon.php'); ?>
                            </div>
                        <?php } ?>
                    </div>
                    <?php 
                    }
                    else {
                    $readcontent = str_word_count(strip_tags($content));
                ?>
                    <div class="art-block-time">
                        <div class="art-text1">
                            <?php

                            $time = round($readcontent / $word_per_minute);
                            $imageCount = substr_count($content, '<img ');
                            $sec = $readcontent / $word_per_minute;
                            $seconds = number_format($sec,3);
                            $total_time = ceil($time + $reading_time_comments);
                            if ($image_include == 1) {
                                // Calculate time for images
                                $image_time_minutes = ($imageCount * $image_per_minute) / 60;

                                // Total reading time including images
                                $total_time = ceil($time + $image_time_minutes + $reading_time_comments);
                            }
                            if ($total_time == 1) {
                                $total_time .= __(' min', 'article-read-time');
                                echo esc_html($total_time);
                            } elseif ($total_time < 1) {
                                $seconds .= __(' sec', 'article-read-time');
                                echo esc_html($seconds);
                            } else {
                                $total_time .= __(' min', 'article-read-time');
                                echo esc_html($total_time);
                            }


                            ?>
                        </div>
                        <?php
                        if ($template_class == "art-block-template-1" || $template_class == "art-block-template-3" || $template_class == "art-block-template-5") { ?>
                            <div class="art-text2">
                                <?php echo esc_html((!empty($art_settings['layout']['read_field_label']))) ? esc_html($art_settings['layout']['read_field_label']) : ''; ?>
                            </div>
                        <?php } else { ?>
                            <div class="art-text2">

                                <?php include(ART_PATH . 'assets/icons/time-icon.php'); ?>
                            </div>
                        <?php } ?>
                    </div>
                <?php } }  ?>
            </div>
        </div>
    </div>
</div>